﻿using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace Vimt.JsonWebToken.Messages.Messages
{
    /// <summary>
    /// Vimt Jwt Encrypt Token Response.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.VimtJwtEncryptTokenResponse)]
    [DataContract]
    public class VimtJwtEncryptTokenResponse : MessageBase
    {
        /// <summary>
        /// Gets/Sets Encrypted JWT.
        /// </summary>
        [DataMember]
        public string EncryptedJwtToken { get; set; }

        /// <summary>
        /// Gets/Sets whether Exception occurred.
        /// </summary>
        [DataMember]
        public bool ExceptionOccured { get; set; }

        /// <summary>
        /// Gets/Set Exception message.
        /// </summary>
        [DataMember]
        public string ExceptionMessage { get; set; }
    }
}